﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="order_edit.aspx.cs" Inherits="VA.Modules.JDingCYT.order.order_edit" %>

<%@ Register src="uc_foodmenu.ascx" tagname="uc_foodmenu" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>
    <!--#include virtual="/include/css/edit.aspx"-->
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/tabs.css" type="text/css" rel="Stylesheet" />
    <link href="/uicontrols/jtongui/themes/<% = webSiteConfig.ThemeName %>/accordion.css" type="text/css" rel="Stylesheet" />
    <!--#include virtual="/include/js/edit.aspx"-->         
    <script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.tabs.js"></script>
    <script type="text/javascript" src="/uicontrols/jtongui/plugins/jtong.accordion.js"></script>
    <script type="text/javascript" src="/scripts/page/order_edit.js"></script>
    <script type="text/javascript">

    var currActType = "";

    //保存菜单
    function save() {

        var tableNo = $("#txtTableNo").val().trim();
        var tableNo2 = $("#hfTableNo").val().trim();

        if (tableNo == "") {
            JTongAlert('提示', "“餐台号”不能为空！", 'warning');
            return;
        }

        if (tableNo != tableNo2) {
            JTongAlert('提示', "“餐台号”异常，请重新下单！", 'warning');
            return;
        }

        if (!formEditListTable_checkTableData()) {
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=update";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("保存成功！", true, doAfterAdd);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd);
            }
            else {
                showActResult("保存失败：" + data, false, doAfterAdd);
            }
        };

        currActType = "save";
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    function doAfterAdd(actResult) {
        if (actResult) {
            $("#btnSubmit").attr("disabled", "disabled");
            window.location.reload();

            var oprType = $("#hfOperateType").val();
            if (currActType == "cxbill") {
                if (oprType == "2") {
                    refreshWorkPlat(); //刷新点餐台      
                    window.parent.refresh();
                } else {
                    refreshWorkPlat(); //刷新点餐台          
                    closeActivatedTopestWindow(); //关闭当前窗口；
                }
            }            
        }
    }

    //结账
    function settle(customerType) {
        var orderNo = $("#hfKey").val();
        var tableNo = $("#txtTableNo").val();
        var currentWindowTitle = "菜单(" + tableNo + ")";
        var oprType = $("#hfOperateType").val();
        var url = "/modules/cyt/consume/charge_by_order_v2.aspx?orderno=" + orderNo + "&oprtype=" + oprType;

        if (oprType == "2") {
            window.location.href = url;
        } else {
            openTopestWindow("结账(" + tableNo + ")", url);
            closeTargetTopestWindow(currentWindowTitle); //关闭当前窗口；
        }        
    }

    //撤单-填写撤单原因；
    function cxBill() {
        openDivWindow2("填写撤单原因", 350, 180, "winCX", false, 150, 150);
    }    
    //撤单执行；
    function cxSave() {

        var requestType = "POST";
        var url = pageName + "?act=cxbill";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        //var data = $("#form").eq(0).serialize(); //取不到值 ？？
        var data = { "hfReasonContent": $("#hfReasonContent").val(), "hfKey": $("#hfKey").val() };
        var successFN = function (data, textStatus) {
            var bizNo = "";
            if (data.substring(0, 2) == "ok") {
                showActResult("撤单成功！", true, doAfterAdd, bizNo);
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, doAfterAdd, bizNo);
            }
            else {
                showActResult("撤单失败：" + data, false, doAfterAdd, bizNo);
            }
        };

        currActType = "cxbill";
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }
    //取消撤单
    function cxCancel() {
        $('#winCX').window("close");
    }

    //催单；
    function remindOrder() {

        var requestType = "POST";
        var url = pageName + "?act=remind";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        //var data = { "hfKey": $("#hfKey").val() };
        var successFN = function (data, textStatus) {
            showActResult(data, true, null);
        };

        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    //确认菜单
    function checkOrder() {

        if (!formEditListTable_checkTableData()) {
            return;
        }

        var requestType = "POST";
        var url = pageName + "?act=check";  //pageName在BasePage中注册到的客户端；
        var dataType = "html";
        var data = $("form").eq(0).serialize();
        var successFN = function (data, textStatus) {
            if (data == "ok") {
                showActResult("确认成功！", true, function () { window.location.reload(); });
            } else if (data.indexOf("01|") != -1) {
                showActResult(data.substring(3), false, null);
            }
            else {
                showActResult("确认失败：" + data, false, null);
            }
        };
        ajaxRequest(requestType,
            url,
            dataType,
            data,
            successFN,
            errorFN
            );
    }

    //上齐；
    function releaseOrder() {

        JTongAlertConfirm("确定菜已上齐吗？", function () {
            var requestType = "POST";
            var url = pageName + "?act=releaseorder";  //pageName在BasePage中注册到的客户端；
            var dataType = "html";
            var data = $("form").eq(0).serialize();

            var successFN = function (data, textStatus) {
                if (data == "ok") {
                    showActResult("操作成功！", true, function () { window.location.reload(); });
                } else if (data.indexOf("01|") != -1) {
                    showActResult(data.substring(3), false, null);
                }
                else {
                    showActResult("操作失败：" + data, false, null);
                }
            };

            ajaxRequest(requestType,
                url,
                dataType,
                data,
                successFN,
                errorFN
                );
        });
    }    

    function close() {
        closeTopestSelectedWindow(); //关闭当前窗口；
    }

    function printOrder() {
        var orderNo = $("#hfKey").val();
        printBill("10", orderNo);       
    }

    function changeHistory() {
        var orderNo = $("#hfKey").val();
        openFrameWindow("调菜记录", 700, 450, "order_change_list.aspx?orderno=" + orderNo, false);
    }

    //从弹出窗口中获取餐台信息
    function takeTableInfo(trObj) {
        closeFrameWindow();
        var tableNo = $(trObj).find("td.tableNo").eq(0).html();
        $("#txtTableNo").val(tableNo);
        $("#hfTableNo").val(tableNo);
    }

        function ddlCXReason_onChange() {
            var reasonText = $("#ddlCXReason").val();
            $("#hfReasonContent").val(reasonText);
            if (reasonText == "其它原因") {
                $("#txtCustomReason").val("");
                $("#txtCustomReason").show();
                $("#txtCustomReason").focus();
            } else {
                $("#txtCustomReason").hide();
            }
        }

        $(function () {        
            var oprType = $("#hfOperateType").val();
            if (oprType == "2") {
                $("#btnClose").hide();
            }

            JTongTabs_init();
            JTongAccordion_init();

            loadFavItems();
            loadGroups();

            $("#txtCustomReason").hide();
            $("#txtCustomReason").blur(function () {
                $("#hfReasonContent").val($("#txtCustomReason").val());
            });
            $("#ddlCXReason").change(function () {
                ddlCXReason_onChange();
            });
            ddlCXReason_onChange();

            $("#txtQuantity2").keydown(function (event) {
                var keyCode = event.keyCode;
                if (keyCode == 13) {
                    takeQuantityCallback();
                };
            });
        });

    </script>

</head>
<body>
<form id="Form1" method="post" runat="server">

<div id="pageWrapper" class="pageWrapper" style="height:1%;overflow:hidden;">

<div class="editPageWrapper" style="width:580px;float:left;">

<div class="centerFormTitle">
   <h1><% = base.orderInfo.Table_No %>号台菜单（序号：<% = base.orderInfo.Order_SequenceNo %>，状态：<% =VA.Modules.JDingCYT.Core.Enums.OrderConverter.OrderBizStatusConverter.Convert_Value_ToText(base.orderInfo.Order_Biz_Status)%>）</h1>
</div>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">餐 台 号：</td>
<td style="width:200px;">
    <asp:TextBox runat="server" ID="txtTableNo" 
            CssClass="input" 
            Width="100px"
            MaxLength="20"
            Font-Size="16px"
            Font-Bold="true" />
    <asp:HiddenField ID="hfTableNo" runat="server" />
    <input type="button" id="btnBrowseTables" runat="server" class="simpleBtn" onclick="browseTables()" value="浏览" />    
</td>
<td class="th">就餐人数：</td>
<td style="width:200px;">
    <asp:DropDownList ID="ddlCustomerQuantity" runat="server" Width="100px" Font-Bold="true" Font-Size="16px">
    </asp:DropDownList>
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th" style="font-weight:bold;text-align:left;">点单明细</td>
</tr>
</table>
<div class="formEditListTableWrapper" style="min-height:311px;">
<table cellspacing="0" class="formEditListTable" id="srcTable" style="margin-top:-1px;">
<thead>
<tr>
<td style="width:30px;text-align:center;">No.</td>
<td style="width:70px;text-align:center;display:none;">项目代码</td>
<td style="width:160px;text-align:center;">品名</td>
<td style="width:40px;text-align:center;">单位</td>
<td style="width:50px;text-align:center;">单价</td>    
<td style="width:40px;text-align:center;">数量</td>
<td style="width:60px;text-align:center;">金额</td>
<td style="width:80px;text-align:center;">口味</td>
<td style="width:30px;text-align:center;">赠送</td>
<td style="width:30px;text-align:center;">上菜</td>
<td style="text-align:center;">操作</td>
</tr>    
</thead>    

<tbody>
</tbody>
</table>

<table id="tbNoRecord" cellspacing="0" cellpadding="3" style="margin-top:-1px;width:100%;">
<tr>
<td style="text-align:center;height:269px;font-size:14px;">
    暂无数据
</td>
</tr>
</table>
</div><!--formEditListTableWrapper.END-->

<table id="Table1" cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td style="text-align:right;">
    <div style="overflow:hidden;">
        <div style="float:left;">
            <asp:CheckBox ID="ckbItemMerge" runat="server" Text="相同项数量合并" Checked="true" />
        </div>
        <div style="float:right;">
            菜品/商品：
            <VACTL:TextBox ID="txtItemName" Runat="server"
                        EnableViewState="False"
                        CssClass="input"
                        Width="200px"
                        />
            <asp:HiddenField runat="server" id="txtItemName_hiddenValue" />  
            <asp:HiddenField runat="server" id="txtItemName_CustomParms" Value="itemtype=2,3" />  
           <%-- <input type="button" id="btnClearItems" class="simpleBtn" onclick="clearItems()" value="清除" />    --%>
        </div>
    </div>      
</td>
</tr>
</table>

<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="th">服务员：</td>
<td style="width:200px;">
    <VACTL:TextBox ID="txtWaiter" Runat="server"
                EnableViewState="False"
                CssClass="input"
                onfocus="JTongSmartDropDownList_OnfocusHandler(this, '../smartdropdownlist_datasrc/get_employees.aspx',true,true,300,180);"
                Width="100px"
                />
    <asp:HiddenField runat="server" id="txtWaiter_hiddenValue" />  
    <asp:HiddenField runat="server" id="txtWaiter_CustomParms" Value="employeetype=2" />  
    <input type="button" id="btnClearWaiters" class="simpleBtn" onclick="clearWaiters()" value="清除" />    
</td>
<td class="th">备注：</td>
<td style="width:200px;">
    <VACTL:TextBox ID="txtRemark" Runat="server"
        EnableViewState="False"
        CssClass="input"
        Width="190"
        MaxLength="100"
        />        
</td>
</tr>
<tr>
<%--<td class="th">开单信息：</td>--%>
<td colspan="4" style="font-size:12px;background-color:#f5f5f5;line-height:150%;">
    单号：<% = base.orderInfo.Order_No %>，开单时间：<% = base.orderInfo.Order_Date.ToString("yyyy-MM-dd HH:mm") %>，用餐时长：<% = VA.Modules.JDingCYT.Core.Utils.FormTimespanString(base.orderInfo.Order_Date, DateTime.Now) %>，
    开单类型：<% = VA.Modules.JDingCYT.Core.Enums.OrderConverter.OrderManTypeConverter.Convert_Value_ToText(base.orderInfo.OrderMan_Type) %>，开单人：<% = base.orderInfo.OrderMan_Name %>，打印次数：<% = base.orderInfo.Print_Count.ToString() %>
</td>
</tr>
</table>


<table cellspacing="0" cellpadding="3" class="editTable" style="margin-top:-1px;">
<tr>
<td class="footer">

    <input type="button" id="btnNext" class="btn" style="width:80px" onclick="save()" value="保存菜单" />
    <input type="button" id="btnPrintOrder" class="btn" style="width:60px" onclick="printOrder()" value="打印" />
    
    <% if (base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.NewOrder.ToString("d")) {%>
        <input type="button" id="Button1" class="btn" style="width:60px" onclick="checkOrder()" value="确认" />
    <% } else if (base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Checked.ToString("d") || 
                    base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Processing.ToString("d") ) {%>
        <input type="button" id="btnRemindOrder" class="btn" style="width:60px" onclick="remindOrder()" value="催单" />             
    <% } %>
        

    <% if (base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Checked.ToString("d") || 
            base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Processing.ToString("d") ||
            base.orderInfo.Order_Biz_Status == VA.Modules.JDingCYT.Core.Enums.Order.OrderBizStatus.Prepared.ToString("d")) {%>
            
        <input type="button" id="btnRelease" class="btn" style="width:60px" onclick="releaseOrder()" value="上齐" />   

    <% } %>        

    <input type="button" id="btnFreeCustomerSettle" class="btn" style="width:60px" onclick="settle(2)" value="结账" />
    <%--<input type="button" id="btnMemberSettle" class="btn" style="width:80px" onclick="settle(1)" value="结账" />--%>
    <input type="button" id="btnCx" class="btn" style="width:60px" onclick="cxBill()" value="撤单" />
    <input type="button" id="btnChangeHistory" class="btn" onclick="changeHistory()" value="调菜记录" />   
    <input type="button" id="btnClose" class="btn" style="width:60px" onclick="cancel()" value="关闭" />
    <asp:HiddenField ID="hfKey" runat="server" />
    <asp:HiddenField ID="hfDataVersionNum" runat="server" />
    
    <!--存储操作类型。1或空-代表直接从tab窗口打开，2-代表从“待结账单”中打开-->
    <input type="hidden" id="hfOperateType" value="<%= Request.QueryString["oprtype"]%>" />
    
    <VACTL:Hint ID="Hint1" runat="server" HintImageUrl="/admin/app_themes/default/images/textbox" />
    <VACTL:ValidationSummary ID="ValidationSummary1" runat="server"
            DisplayMode="List"
            EnableClientScript="true" />
    
    <!--注意：这个文件一定要放到页面底部，以便覆盖asp.net验证脚本中的同名函数-->
    <script type="text/javascript" src="/scripts/utils/aspnet_validator_extend.js"></script>
</td>
</tr>
</table>

</div><!--editPageWrapper.END-->

</div><!--"wrapper.END"-->

<div id="divFavPanel" style="z-index:0;width:250px;height:503px;position:absolute;left:595px;top:44px;padding:0px;">
    <uc1:uc_foodmenu ID="uc_foodmenu1" runat="server" MainHeight="484" />
</div>

<div id="winEditor" style="display:none;">                            
    <div style="margin:auto;">
    <table cellspacing="0" cellpadding="3" class="editTable">    
    <tr>
    <td class="th" style="width:60px;">数量：</td>
    <td>    	  
        <VACTL:TextBox runat="server" ID="txtQuantity2" 
            CssClass="input" 
            Width="100px"
            Height="30px"
            Font-Size="20px"
            Font-Bold="true"
            CanBeNull="No"
            FieldName="数量"
            RequiredFieldType="Numeric"
            Text="1"
            />
        <input type="button" id="btnPlus" class="btn" style="width:25px" onclick="changeQuantity('+','txtQuantity2')" value="+" />            
        <input type="button" id="btnSubtract" class="btn" style="width:25px" onclick="changeQuantity('-','txtQuantity2')" value="-" />

    </td>
    </tr>
    <tr>
    <td colspan="2" class="footer">

        <input type="button" id="Button2" class="btn" style="width:80px" onclick="takeQuantityCallback()" value="确定" />
        <input type="button" id="Button3" class="btn" style="width:80px" onclick="takeQuantityCancel()" value="取消" />

    </td>
    </tr>
    </table>
    </div>
</div> 


<!--每个页面上只能有一个该控件实例-->
<VACTL:SmartDropDownList ID="SmartDropDownList1" runat="server"></VACTL:SmartDropDownList>  

<% if (base.orderInfo != null){ %>
<%
    
    Response.Write("<script type=\"text/javascript\">");       
    Response.Write("var itemList = [");       
       
    var i = 0;       
    foreach (VA.Modules.JDingCYT.Core.Model.MainBiz.OrderItemInfo item in base.orderInfo.OrderItems)
    {
        string RID = item.RID.ToString();
        string itemType = item.Item_Type;
        string itemCategory = item.Item_Category;
        string itemCode = item.Item_Code;
        string itemName = item.Item_Name;
        string unit = item.Unit;
        string price = item.Price.ToString("F2");        
        string quantity = item.Quantity.ToString();
        string zuofa = item.Zuofa.Replace(",","，").Replace("\"","“").Replace("\'","‘");
        string donateFlag = item.Donate_Flag;
        string bizStatus = item.Biz_Status;

        Response.Write("{");
        Response.Write("\"itemType\":\"" + itemType + "\",\"itemCategory\":\"" + itemCategory + "\",\"itemName\":\"" + itemName + "\",\"itemCode\":\"" + itemCode + "\",\"unit\":\"" + unit + "\",\"price\":\"" + price + "\",\"quantity\":\"" + quantity + "\",\"zuofa\":\"" + zuofa + "\",\"donateFlag\":\"" + donateFlag + "\",\"RID\":\""+ RID +"\",\"bizStatus\":\"" + bizStatus + "\"");

        if (i == base.orderInfo.OrderItems.Count - 1)
            Response.Write("}");
        else
            Response.Write("},");
        
        i++;
    }

    Response.Write("];");      
    Response.Write("</script>");        
%>

<script type="text/javascript">
    var orignalFlag = "1";
    for (var i = 0; i < itemList.length; i++) {
        formEditListTable_addRow(
        itemList[i].itemType,
        itemList[i].itemCategory,
        itemList[i].itemCode,
        itemList[i].itemName,
        itemList[i].unit,
        itemList[i].price,
        itemList[i].quantity,
        itemList[i].zuofa,
        itemList[i].donateFlag,
        orignalFlag,
        itemList[i].bizStatus);
    }
</script>

<% } %>

<!--撤单详情窗口-->
<div id="winCX" style="display:none;">

    <div style="width:300px;padding:10px;margin:auto;">

    <div class="centerFormTitle">
        <h1>填写撤单原因</h1>
    </div>

    <table cellspacing="0" cellpadding="3" class="editTable" style="margin:auto;">      
    <tr>
    <td class="th">撤单原因：</td>
    <td>    
        <asp:DropDownList ID="ddlCXReason" runat="server" EnableViewState="false">
        <asp:ListItem Value="顾客退单" Selected="True">顾客退单</asp:ListItem>
        <asp:ListItem Value="菜已售完">菜已售完</asp:ListItem>
        <asp:ListItem Value="其它原因">其它原因</asp:ListItem>
        </asp:DropDownList>          
        <input type="text" class="input" style="width:90px;" id="txtCustomReason" name="txtCustomReason" maxlength="20" />
        <input type="hidden" class="input" style="width:90px;" id="hfReasonContent" name="hfReasonContent" maxlength="20" />
    </td>
    </tr> 
    <tr>
    <td colspan="2" class="footer">
        <input type="button" id="btnCXBill" class="btn" style="width:80px" onclick="cxSave()" value="撤单" />
        <input type="button" id="btnCxCancel" class="btn" style="width:80px" onclick="cxCancel()" value="取消" />
    </td>
    </tr>
    </table>

    </div>

</div> 

</form>
</body>
</html>

